<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSellingUnitVpeEventListener.php 2020-03-18
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Shop\Properties\SellingUnitVpe\Listeners;

use Gambio\Shop\Properties\Database\Services\Interfaces\PropertiesReaderServiceInterface;
use Gambio\Shop\Properties\Properties\Collections\CombinationCollectionInterface;
use Gambio\Shop\Properties\Properties\Entities\Combination;
use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitVpeEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Vpe;

class OnGetSellingUnitVpeEventListener
{
    /**
     * @var PropertiesReaderServiceInterface
     */
    protected $service;

    /**
     * OnGetSellingUnitVpeEventListener constructor.
     * @param PropertiesReaderServiceInterface $service
     */
    public function __construct(PropertiesReaderServiceInterface $service)
    {
        $this->service = $service;
    }

    /**
     * @param OnGetSellingUnitVpeEventInterface $event
     */
    public function __invoke(OnGetSellingUnitVpeEventInterface $event)
    {
        $combinations = $this->service->getCombinationsFor($event->id());

        if (count($combinations) === 1) {
            $event->setVpe($combinations[0]->vpe());
        }

        if (count($combinations) > 1) {
            $event->setVpe($this->getCheapestCombinationVpe($combinations));
        }
    }

    /**
     * @param float $vpeValue
     * @param int $vpeId
     * @return Vpe
     */
    protected function createVpe(float $vpeValue, int $vpeId): Vpe
    {
        return new Vpe($vpeId, $vpeValue);
    }

    /**
     * @param CombinationCollectionInterface $combinations
     * @return Vpe|null
     */
    protected function getCheapestCombinationVpe(CombinationCollectionInterface $combinations): ?Vpe
    {
        $priceArray = [];
        /** @var Combination $combination */
        foreach ($combinations as $combination) {
            if ($combination->surcharge() && !$combination->surcharge()->isNonLinear()) {
                if(!isset($priceArray[(string)$combination->surcharge()->value()]))
                    $priceArray[(string)$combination->surcharge()->value()] = [];
                $priceArray[(string)$combination->surcharge()->value()][$combination->order()->value()] = $combination;
            }
        }
        if (count($priceArray)) {
            //sort to get the cheapest one
            ksort($priceArray);
            $sorted = array_values($priceArray);
            ksort($sorted[0]);
            $sorted =array_values($sorted[0]);
            return $sorted[0]->vpe();
        }

        return null;

    }

}